/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.impl;

import com.quantumdata.sct.dao.exception.CreateException;
import com.quantumdata.sct.dao.exception.DAOException;
import com.quantumdata.sct.dao.exception.ReadException;
import com.quantumdata.sct.dao.impl.AbstractXMLStorageDAO;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.jaxb.ModelCapabilities;
import com.quantumdata.sct.dao.jaxb.ModelCapabilitiesType;
import com.quantumdata.sct.dao.jaxb.ModelCapability;
import com.quantumdata.sct.dao.jaxb.ModelCapabilityParameterType;
import com.quantumdata.sct.dao.vo.ModelCapabilityVO;
import com.quantumdata.sct.util.keygen.KeyGenerator;
import com.quantumdata.sct.util.keygen.RandTSKeyGenerator;
import java.util.ArrayList;
import java.util.Iterator;

public final class ModelCapabilityDAO
extends AbstractXMLStorageDAO {
    private KeyGenerator keygen = RandTSKeyGenerator.instance();

    private ModelCapabilitiesType.ModelCapability get(Integer n) throws ReadException {
        if (n == null) {
            throw new ReadException("Invalid index");
        }
        int n2 = ((ModelCapabilities)this.daoObject).getModelCapabilityCollection().size();
        if (n >= n2) {
            throw new ReadException("Index out of bounds error");
        }
        ModelCapabilitiesType.ModelCapability modelCapability = (ModelCapabilitiesType.ModelCapability)((ModelCapabilities)this.daoObject).getModelCapabilityCollection().get(n);
        return modelCapability;
    }

    public void readCallback() throws DAOException {
        try {
            ModelCapabilities modelCapabilities = (ModelCapabilities)this.daoObject;
            int n = modelCapabilities.getModelCapabilityCollection().size();
            this.daoCollection.clear();
            for (int i = 0; i < n; ++i) {
                ModelCapabilitiesType.ModelCapability modelCapability = (ModelCapabilitiesType.ModelCapability)modelCapabilities.getModelCapabilityCollection().get(i);
                this.daoCollection.put(modelCapability.getModelId(), new Integer(i));
            }
            this.initialize = true;
        }
        catch (Exception exception) {
            this.initialize = false;
            throw new DAOException("Unable to load", null, exception);
        }
    }

    public final Object getUniqueKey() {
        return this.keygen.generateUniqueKey();
    }

    public final IPersistable getValueObjectForKey(Object object) throws CreateException {
        IPersistable iPersistable = null;
        try {
            if (!this.daoCollection.containsKey(object)) {
                throw new Exception("Element with key = " + object + " not found");
            }
            Integer n = (Integer)this.daoCollection.get(object);
            ModelCapabilitiesType.ModelCapability modelCapability = this.get(n);
            iPersistable = this.createPersistable(modelCapability);
        }
        catch (Exception exception) {
            throw new CreateException(exception.getMessage());
        }
        return iPersistable;
    }

    public final IPersistable[] findByAll() throws Exception {
        int n = ((ModelCapabilities)this.daoObject).getModelCapabilityCollection().size();
        IPersistable[] iPersistableArray = new IPersistable[n];
        for (int i = 0; i < n; ++i) {
            ModelCapabilitiesType.ModelCapability modelCapability = (ModelCapabilitiesType.ModelCapability)((ModelCapabilities)this.daoObject).getModelCapabilityCollection().get(i);
            iPersistableArray[i] = this.createPersistable(modelCapability);
        }
        return iPersistableArray;
    }

    public final Object getUniqueKey(Object object) {
        Object object2 = null;
        if (object instanceof ModelCapabilitiesType.ModelCapability) {
            ModelCapabilitiesType.ModelCapability modelCapability = (ModelCapabilitiesType.ModelCapability)object;
            object2 = modelCapability.getModelId();
        } else {
            object2 = this.getUniqueKey();
        }
        return object2;
    }

    private IPersistable createPersistable(Object object) throws Exception {
        ModelCapabilityVO modelCapabilityVO = new ModelCapabilityVO();
        if (object instanceof ModelCapabilitiesType.ModelCapability) {
            this.copyFrom((ModelCapabilitiesType.ModelCapability)object, modelCapabilityVO);
        }
        return modelCapabilityVO;
    }

    private void copyFrom(ModelCapabilitiesType.ModelCapability modelCapability, ModelCapabilityVO modelCapabilityVO) throws Exception {
        modelCapabilityVO.setId(modelCapability.getModelId());
        modelCapabilityVO.setLastUpdate(modelCapability.getLastUpdate());
        ArrayList<ModelCapabilityVO.ModelCapabilityElementVO> arrayList = new ArrayList<ModelCapabilityVO.ModelCapabilityElementVO>();
        int n = modelCapability.getCapabilities().size();
        for (int i = 0; i < n; ++i) {
            ModelCapability.ModelCapabilityElement modelCapabilityElement = (ModelCapability.ModelCapabilityElement)modelCapability.getCapabilities().get(i);
            ModelCapabilityVO.ModelCapabilityElementVO modelCapabilityElementVO = new ModelCapabilityVO.ModelCapabilityElementVO();
            modelCapabilityElementVO.setCapabilityId(modelCapabilityElement.getCapabilityId());
            modelCapabilityElementVO.setSupported(modelCapabilityElement.isSupported());
            ModelCapabilityParameterType modelCapabilityParameterType = modelCapabilityElement.getModelCapabilityParameter();
            if (modelCapabilityParameterType != null) {
                modelCapabilityElementVO.setName(modelCapabilityParameterType.getParameterName());
                modelCapabilityElementVO.setValue(modelCapabilityParameterType.getParameterValue());
            }
            arrayList.add(modelCapabilityElementVO);
        }
        modelCapabilityVO.setCapabilities(arrayList);
    }

    private void copyTo(ModelCapabilitiesType.ModelCapability modelCapability, ModelCapabilityVO modelCapabilityVO) throws Exception {
        modelCapability.setModelId((String)modelCapabilityVO.getId());
        modelCapability.setLastUpdate(modelCapabilityVO.getLastUpdate());
        Iterator iterator = modelCapabilityVO.getCapabilities().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ModelCapability.ModelCapabilityElement modelCapabilityElement = this.factory.createModelCapabilityModelCapabilityElement();
            ModelCapabilityVO.ModelCapabilityElementVO modelCapabilityElementVO = (ModelCapabilityVO.ModelCapabilityElementVO)iterator.next();
            modelCapabilityElement.setSupported(modelCapabilityElementVO.isSupported());
            modelCapabilityElement.setCapabilityId(modelCapabilityElementVO.getCapabilityId());
            if (modelCapabilityElementVO.getName() != null && modelCapabilityElementVO.getName().trim().length() != 0) {
                ModelCapabilityParameterType modelCapabilityParameterType = this.factory.createModelCapabilityParameterType();
                modelCapabilityParameterType.setParameterName(modelCapabilityElementVO.getName());
                modelCapabilityParameterType.setParameterValue(modelCapabilityElementVO.getValue());
                modelCapabilityElement.setModelCapabilityParameter(modelCapabilityParameterType);
            }
            modelCapability.getCapabilities().add(modelCapabilityElement);
            ++n;
        }
    }

    protected final void updateObject(IPersistable iPersistable) throws Exception {
        if (iPersistable instanceof ModelCapabilityVO) {
            ModelCapabilityVO modelCapabilityVO = (ModelCapabilityVO)iPersistable;
            Integer n = (Integer)this.daoCollection.get(modelCapabilityVO.getId());
            ModelCapabilitiesType.ModelCapability modelCapability = this.get(n);
            modelCapability.getCapabilities().clear();
            this.copyTo(modelCapability, modelCapabilityVO);
            this.flush();
        }
    }

    protected final IPersistable findByPrimaryKey(String string) {
        ModelCapabilityVO modelCapabilityVO = null;
        try {
            if (this.daoCollection.containsKey(string)) {
                Integer n = (Integer)this.daoCollection.get(string);
                ModelCapabilitiesType.ModelCapability modelCapability = this.get(n);
                modelCapabilityVO = new ModelCapabilityVO();
                this.copyFrom(modelCapability, modelCapabilityVO);
            }
        }
        catch (Exception exception) {
            this.log(exception.getMessage());
            modelCapabilityVO = null;
        }
        return modelCapabilityVO;
    }

    protected final void removeByPrimaryKey(Object object) throws DAOException {
        try {
            if (object instanceof String) {
                Integer n = (Integer)this.daoCollection.get(object);
                ((ModelCapabilities)this.daoObject).getModelCapabilityCollection().remove(n);
            }
            this.flush();
            this.readCallback();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DAOException(throwable.getMessage());
        }
    }

    public final void add(IPersistable iPersistable) throws CreateException {
        this.add(iPersistable, 0);
    }

    public final void add(IPersistable iPersistable, int n) throws CreateException {
        try {
            if (iPersistable instanceof ModelCapabilityVO) {
                ModelCapabilitiesType.ModelCapability modelCapability = this.factory.createModelCapabilitiesTypeModelCapability();
                this.copyTo(modelCapability, (ModelCapabilityVO)iPersistable);
                this.validator.validate((Object)modelCapability);
                if (n > 0) {
                    ((ModelCapabilities)this.daoObject).getModelCapabilityCollection().add(n, modelCapability);
                } else {
                    ((ModelCapabilities)this.daoObject).getModelCapabilityCollection().add(modelCapability);
                }
            } else {
                throw new Exception("Invalid Value Object being passed");
            }
            this.flush();
            this.readCallback();
        }
        catch (Exception exception) {
            throw new CreateException("Unable to add element = " + iPersistable.getId(), null, exception);
        }
    }
}

